<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Customer extends Model 
{

    protected $table = 'customers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('password', 'facebook_id', 'google_id');
    protected $fillable = array('name', 'birthday', 'gender', 'email', 'show_tutorial', 'picture', 'smoke', 'status_id');
    protected $hidden = array('password', 'facebook_id', 'google_id');

    public function status()
    {
        return $this->belongsTo('Status');
    }

}